@extends('adminlte::page')

@section('title', 'Daftar Tagihan Pelanggan')

@section('content')
<div class="container">
    <h2 class="mb-3">Daftar Tagihan Pelanggan</h2>
    <div class="row mb-3 align-items-center">
        <div class="col">
            <form method="GET" action="{{ route('pembayaran.index') }}" class="form-row justify-content-end">
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <input type="text" name="q" class="form-control" placeholder="Cari Nama" value="{{ request('q') }}">
                </div>
                <div class="col-12 col-md-auto mb-2 mb-md-0">
                    <select name="grub_id" class="form-control">
                        <option value="">-- Semua Grub --</option>
                        @foreach($grubs as $grub)
                            <option value="{{ $grub->id }}" {{ request('grub_id') == $grub->id ? 'selected' : '' }}>
                                {{ $grub->nama_grub }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <!--<div class="col-12 col-md-auto mb-2 mb-md-0">
                    <select name="status" class="form-control">
                        <option value="">-- Status Tagihan --</option>
                        <option value="lunas" {{ request('status') == 'lunas' ? 'selected' : '' }}>Lunas</option>
                        <option value="belum_lunas" {{ request('status') == 'belum_lunas' ? 'selected' : '' }}>Belum Lunas</option>
                    </select>
                </div>-->
                <div class="col-12 col-md-auto">
                    <button type="submit" class="btn btn-primary mr-1">Filter</button>
                    <a href="{{ route('pembayaran.index') }}" class="btn btn-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card shadow-sm">
        <div class="card-body p-2">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped table-sm mb-0 align-middle">
                    <thead class="bg-gradient-primary text-white text-center">
                        <tr>
                            <th style="width:40px;">No</th>
                            <th>Pelanggan</th>
                            <th>Grub</th>
                            <th>Bulan</th>
                            <th>Tanggal Tagihan</th>
                            <th class="text-right">Tagihan (Rp)</th>
                            <th class="text-right">Pembayaran (Rp)</th>
                            <th>Status</th>
                            <th style="width:70px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pembayarans as $pembayaran)
                        @php
                            $periode = $pembayaran->periode;
                            $tgl_berlangganan = $pembayaran->pelanggan->tanggal_berlangganan ?? null;
                            $day = $tgl_berlangganan ? \Carbon\Carbon::parse($tgl_berlangganan)->day : 1;
                            $tanggal_tagihan = $periode ? \Carbon\Carbon::createFromFormat('Y-m', $periode)->day($day) : null;
                        @endphp
                        <tr>
                            <td>{{ $loop->iteration + ($pembayarans->currentPage()-1)*$pembayarans->perPage() }}</td>
                            <td style="min-width:110px">
                                {{ $pembayaran->pelanggan->nama ?? '-' }}
                                @if($pembayaran->pelanggan->status == 'suspend')
                                    <span class="badge badge-danger ml-1">Suspend</span>
                                @endif
                            </td>
                            <td>{{ $pembayaran->pelanggan->grub->nama_grub ?? '-' }}</td>
                            <td>{{ $periode ? \Carbon\Carbon::createFromFormat('Y-m', $periode)->translatedFormat('F Y') : '-' }}</td>
                            <td>{{ $tanggal_tagihan ? $tanggal_tagihan->format('d-m-Y') : '-' }}</td>
                            <td class="text-right">{{ number_format($pembayaran->jumlah_tagihan, 0, ',', '.') }}</td>
                            <td class="text-right">{{ number_format($pembayaran->jumlah_dibayar, 0, ',', '.') }}</td>
                            <td>
                                @if($pembayaran->jumlah_dibayar >= $pembayaran->jumlah_tagihan)
                                    <span class="badge badge-success w-100">Lunas</span>
                                @else
                                    <span class="badge badge-warning text-dark w-100">Belum Lunas</span>
                                @endif
                            </td>
                            <td>
                                @if($pembayaran->jumlah_dibayar < $pembayaran->jumlah_tagihan)
                                    <button class="btn btn-success btn-sm w-100"
                                            data-toggle="modal"
                                            data-target="#modalBayar{{ $pembayaran->id }}">
                                        Bayar
                                    </button>
                                @else
                                    <span class="btn btn-secondary btn-sm w-100" disabled>Sudah Dibayar</span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                        @if($pembayarans->count() == 0)
                        <tr>
                            <td colspan="9" class="text-center">Tidak ada data pembayaran</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="mt-2 mb-0">
                {{ $pembayarans->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
</div>

<!-- MODAL PEMBAYARAN -->
@foreach($pembayarans as $pembayaran)
<div class="modal fade" id="modalBayar{{ $pembayaran->id }}" tabindex="-1" role="dialog" aria-labelledby="modalBayarLabel{{ $pembayaran->id }}" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form method="POST" action="{{ route('pembayaran.bayar.submit', $pembayaran->id) }}">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalBayarLabel{{ $pembayaran->id }}">Pembayaran</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-2">
                        <label>Nominal Pembayaran</label>
                        <input type="number"
                               name="jumlah_dibayar"
                               class="form-control"
                               min="1"
                               max="{{ $pembayaran->jumlah_tagihan - $pembayaran->jumlah_dibayar }}"
                               value="{{ $pembayaran->jumlah_tagihan - $pembayaran->jumlah_dibayar }}"
                               required>
                        <small class="form-text text-muted">
                            Maksimal pembayaran: Rp{{ number_format($pembayaran->jumlah_tagihan - $pembayaran->jumlah_dibayar,0,',','.') }}
                        </small>
                    </div>
                    <input type="hidden" name="pembayaran_id" value="{{ $pembayaran->id }}">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Bayar</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endforeach

{{-- CSS tambahan agar tabel makin nyaman di HP --}}
<style>
@media (max-width: 600px) {
    .table th, .table td {
        font-size: 13px !important;
        padding: 6px 4px !important;
    }
    .table th {
        white-space: nowrap;
    }
    .table td {
        vertical-align: middle;
    }
    .badge, .btn {
        font-size: 12px !important;
        padding: 4px 8px !important;
    }
    .form-control, .btn {
        font-size: 13px !important;
    }
}
</style>
@endsection